<div class="modal fade" id="edit-user-{{ $user->id }}" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-user">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="user-title">Edit user - {{ Str::ucfirst($user->name) }}</h3>
								</div>
								<form action="{{ route('user.update', ['user' => $user]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'err_' . $user->id;
										@endphp
										<div class="col-12 mb-0">
												<label class="form-label" for="name">Full name</label>
												<input type="text" id="name" name="name"
														class="form-control @error('name', $err) is-invalid @enderror" placeholder="Full name" tabindex="-1"
														value="{{ old('name') ?? $user->name }}" />
												@error('name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('name') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="email">Email</label>
												<input type="text" id="email" name="email"
														class="form-control @error('email', $err) is-invalid @enderror" placeholder="Email"
														value="{{ old('email') ?? $user->email }}" />
												@error('email', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('email') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="telephone">Telephone</label>
												<input type="text" id="telephone" name="telephone"
														class="form-control @error('telephone', $err) is-invalid @enderror" placeholder="Telephone"
														value="{{ old('telephone') ?? $user->telephone }}" />
												@error('telephone', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('telephone') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-0">
												<label class="form-label" for="address">Address</label>
												<input type="text" id="address" name="address_1"
														class="form-control @error('address_1', $err) is-invalid @enderror" placeholder="Address"
														value="{{ old('address_1') ?? $user->address }}" />
												@error('address_1', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('address_1') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-3">
												<label class="form-label" for="status">Reseller group</label>
												<select name="reseller_id" class="form-control @error('reseller_id') is-invalid @enderror">
														<option value="">Select reseller</option>
														@foreach ($resellers as $resl)
																<option value="{{ $resl->id }}" @selected((int) old('reseller_id') === $resl->id) @selected($user->reseller === $resl->name)>
																		{{ Str::ucfirst($resl->name) }}
																</option>
														@endforeach
												</select>
												@error('reseller_id')
														<div class="invalid-feedback">{{ $errors->first('reseller_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-3">
												<label class="form-label" for="status">Country</label>
												<select name="country_id" class="form-control @error('country_id', $err) is-invalid @enderror">
														<option value="">Select country</option>
														@foreach ($country as $cont)
																<option value="{{ $cont->id }}" @selected($user->country_id === $cont->id)>
																		{{ Str::ucfirst($cont->name) }}&nbsp;({{ Str::upper($cont->code) }})
																</option>
														@endforeach
												</select>
												@error('country_id', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('country_id') }}</div>
												@enderror
										</div>
										<div class="col-12 mb-3">
												<label class="form-label" for="status">Status</label>
												<select name="status" class="form-control @error('status', $err) is-invalid @enderror">
														<option value="">Select status</option>
														@foreach ($status as $st)
																<option value="{{ $st }}" @selected($user->status === $st)>{{ Str::upper($st) }}</option>
														@endforeach
												</select>
												@error('status', $err)
														<div class="invalid-feedback">{{ $errors->$err->first('status') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
