<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("order_id");
            $table->unsignedBigInteger("parcel_id");
            $table->unsignedBigInteger("receiver_id");
            $table->string("price");
            $table->timestamps();

            $table->foreign("order_id")->references("id")->on("orders")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("parcel_id")->references("id")->on("parcels")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("receiver_id")->references("id")->on("receiver_details")->cascadeOnUpdate()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('details');
    }
};
