<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parcels', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("parcel_category_id");
            $table->string("country_from");
            $table->string("country_to");
            $table->double("length");
            $table->double("height");
            $table->double("width");
            $table->double("weight");
            $table->double("price");
            $table->timestamps();

            $table->foreign("parcel_category_id")->references("id")->on("parcel_categories")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("country_from")->references("name")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign("country_to")->references("name")->on("countries")->cascadeOnUpdate()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parcels');
    }
};
