<?php

namespace App\classes\service;

use App\Models\ParcelCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator as ValidatorReturn;

class ParcelCategoryService
{
  public function Index(Request $request)
  {
    $parcel_categorys =  ParcelCategory::paginate(15);
    return $parcel_categorys;
  }
  public function Create(Request $request)
  {
    $data = [
      "name"        => trim(htmlspecialchars(strtolower($request->name))),
      "length_min"  => (float)trim(htmlspecialchars($request->length_min)),
      "length_max"  => (float)trim(htmlspecialchars($request->length_max)),
      "height_min"  => (float)trim(htmlspecialchars($request->height_min)),
      "height_max"  => (float)trim(htmlspecialchars($request->height_max)),
      "width_min"   => (float)trim(htmlspecialchars($request->width_min)),
      "width_max"   => (float)trim(htmlspecialchars($request->width_max)),
      "weight_min"  => (float)trim(htmlspecialchars($request->weight_min)),
      "weight_max"  => (float)trim(htmlspecialchars($request->weight_max)),
    ];
    return ParcelCategory::create($data);
  }
  public function Update(Request $request, ParcelCategory $parcel_category): ParcelCategory
  {
    $data = [
      "name"        => trim(htmlspecialchars(strtolower($request->name))),
      "length_min"  => (float)trim(htmlspecialchars($request->length_min)),
      "length_max"  => (float)trim(htmlspecialchars($request->length_max)),
      "height_min"  => (float)trim(htmlspecialchars($request->height_min)),
      "height_max"  => (float)trim(htmlspecialchars($request->height_max)),
      "width_min"   => (float)trim(htmlspecialchars($request->width_min)),
      "width_max"   => (float)trim(htmlspecialchars($request->width_max)),
      "weight_min"  => (float)trim(htmlspecialchars($request->weight_min)),
      "weight_max"  => (float)trim(htmlspecialchars($request->weight_max)),
    ];
    $parcel_category->update($data);
    return $parcel_category;
  }

  public function Delete(ParcelCategory $parcel_category): bool
  {
    return $parcel_category->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  ParcelCategory|bool $parcel_category
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, ParcelCategory|bool $parcel_category = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "name"        => ["required", "unique:parcel_categories,name"],
          "length_min"  => ["required", "numeric", "min:0"],
          "length_max"  => ["required", "numeric", "min:0"],
          "height_min"  => ["required", "numeric", "min:0"],
          "height_max"  => ["required", "numeric", "min:0"],
          "width_min"   => ["required", "numeric", "min:0"],
          "width_max"   => ["required", "numeric", "min:0"],
          "weight_min"  => ["required", "numeric", "min:0"],
          "weight_max"  => ["required", "numeric", "min:0"],
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "name" => ["required", Rule::unique("parcel_categories", "name")->ignore($parcel_category->id)],
          "length_min"  => ["required", "numeric", "min:0"],
          "length_max"  => ["required", "numeric", "min:0"],
          "height_min"  => ["required", "numeric", "min:0"],
          "height_max"  => ["required", "numeric", "min:0"],
          "width_min"   => ["required", "numeric", "min:0"],
          "width_max"   => ["required", "numeric", "min:0"],
          "weight_min"  => ["required", "numeric", "min:0"],
          "weight_max"  => ["required", "numeric", "min:0"],
        ]);
      default:
        return null;
    }
  }
}
