<?php

namespace App\Http\Controllers\Admin;

use App\Models\Country;
use App\Models\Reseller;
use App\Models\ParcelPrice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\ParcelPriceService;
use App\Models\ParcelCategory;

class ParcelPriceController extends Controller
{
    private ParcelPriceService $parcel_priceService;

    public function __construct()
    {
        $this->parcel_priceService = new ParcelPriceService();
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $parcel_prices      = $this->parcel_priceService->Index($request);
        $parcelCats         = ParcelCategory::all();
        $reseller           = Reseller::all();
        $country            = Country::all();
        return view("admin.parcel_price.index", compact("parcel_prices", "parcelCats", "reseller", "country"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $this->parcel_priceService->DataValidation($request, "post");
        if ($data->fails()) {
            return back()->withInput()->withErrors($data);
        }
        $parcel_price = $this->parcel_priceService->Create($request);
        return redirect()->route("parcel-price.index")->with("success", "Parcel price successfully created.");
    }

    /**
     * Display the specified resource.
     */
    public function show(ParcelPrice $parcel_price)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ParcelPrice $parcel_price)
    {
        return view("admin.parcel_price.index", compact("parcel_price"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ParcelPrice $parcel_price)
    {
        $data = $this->parcel_priceService->DataValidation($request, "patch", $parcel_price);
        if ($data->fails()) {
            return back()->withInput()->withErrors($data, "err_" . $parcel_price->id)->with("err", $parcel_price->id);
        }
        $parcel_price = $this->parcel_priceService->Update($request, $parcel_price);
        return redirect()->route("parcel-price.index")->with("success", "Parcel price ($parcel_price->country_from => $parcel_price->country_to) successfully updated.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ParcelPrice $parcel_price)
    {
        $name = $parcel_price->name;
        $this->parcel_priceService->Delete($parcel_price);
        return redirect()->route("parcel-price.index")->with("success", "Parcel price ($parcel_price->name) successfully updated.");
    }
}
