<?php

namespace App\Http\Controllers\Admin;

use App\Models\Country;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\CountryService;

class CountryController extends Controller
{
    private CountryService $countryService;

    public function __construct()
    {
        $this->countryService = new CountryService();
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $countrys = $this->countryService->Index($request);
        return view("admin.country.index", compact("countrys"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $this->countryService->DataValidation($request, "post");
        if ($data->fails()) {
            return back()->withInput()->withErrors($data);
        }
        $country = $this->countryService->Create($request);
        return redirect()->route("country.index")->with("success", "Country successfully created.");
    }

    /**
     * Display the specified resource.
     */
    public function show(Country $country)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Country $country)
    {
        return view("admin.country.index", compact("country"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Country $country)
    {
        $data = $this->countryService->DataValidation($request, "patch", $country);
        if ($data->fails()) {
            return back()->withInput()->withErrors($data, "err_" . $country->id)->with("err", $country->id);
        }
        $country = $this->countryService->Update($request, $country);
        return redirect()->route("country.index")->with("success", "Country ($country->name) successfully updated.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Country $country)
    {
        $name = $country->name;
        $this->countryService->Delete($country);
        return redirect()->route("country.index")->with("success", "Country ($country->name) successfully updated.");
    }
}
