<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\maps\Leaflet;
use App\Http\Controllers\apps\AccessRoles;
use App\Http\Controllers\dashboard\Ecommerce;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\apps\AccessPermission;
use App\Http\Controllers\Admin\ModuleController;
use App\Http\Controllers\Admin\StatusController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\CurrencyController;
use App\Http\Controllers\Admin\ResellerController;
use App\Http\Controllers\Admin\CorporateController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\authentications\LoginCover;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\laravel_example\UserManagement;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// AUTH - routes
Route::get("/", [LoginCover::class, "index"]);
Route::get("/login", [LoginCover::class, "index"])->name("login");
Route::post("/login", [AuthController::class, "login"])->name("login.post");
Route::post("/logout", [AuthController::class, "logout"])->name("logout")->middleware("auth:web");
// AUTH - routes

// Main Page Route
// Route::get('/dashboard/ecommerce', [Ecommerce::class, 'index'])->name('dashboard-ecommerce');
Route::group(["prefix" => "admin", "middleware" => "auth:web"], function () {
  Route::get('/', [Ecommerce::class, 'index'])->name('home.admin');
  // Module
  Route::resource("module", ModuleController::class);
  // Status
  Route::resource("status", StatusController::class);
  // Role
  Route::resource("role", RoleController::class);
  // Permission
  Route::resource("permission", PermissionController::class);
  // Module
  Route::resource("country", CountryController::class);
  Route::resource("currency", CurrencyController::class);
  // Users
  Route::resource("reseller", ResellerController::class);
  // Users
  Route::resource("user", UserController::class);
  Route::post("user/{user}/change-password", [UserController::class, "change_password"])->name("user.change-password");
  // Partner
  Route::resource("partner", PartnerController::class);
  // Corporate
  Route::resource("corporate", CorporateController::class);
  // locale
  Route::get('lang/{locale}', [LanguageController::class, "swap"]);
  // maps
  Route::get('/maps/leaflet', [Leaflet::class, 'index'])->name('maps-leaflet');
});
