<?php

namespace App\classes\service;

use App\Models\Currency;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator as ValidatorReturn;

class CurrencyService
{
  public function Index(Request $request)
  {
    $currencies =  Currency::paginate(15);
    return $currencies;
  }
  public function Create(Request $request)
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    $code = trim(strtolower(htmlspecialchars($request->code)));
    return Currency::create(["name" => $name, "code" => $code]);
  }
  public function Update(Request $request, Currency $currency): Currency
  {
    $name = trim(strtolower(htmlspecialchars($request->name)));
    $code = trim(strtolower(htmlspecialchars($request->code)));
    $currency->update(["name" => $name, "code" => $code]);
    return $currency;
  }

  public function Delete(Currency $currency): bool
  {
    return $currency->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  Country|bool $currency
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, Currency|bool $currency = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "name" => ["required", "unique:currencies,name"],
          "code" => ["required", "unique:currencies,code"]
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "name" => ["required", Rule::unique("currencies", "name")->ignore($currency->id)],
          "code" => ["required", Rule::unique("currencies", "code")->ignore($currency->id)]
        ]);
      default:
        return null;
    }
  }
}
