@php
		$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Setting system')

@section('content')
		@include('admin.includes.show-msg')
		<h4 class="py-3 breadcrumb-wrapper mb-2">Setting system List</h4>
		<!-- Role cards -->
		<div class="row g-4">
				<div class="col-xl-12">
						<div class="card h-100">
								<div class="row h-100">
										<div class="col-sm-5">
												<div class="d-flex align-items-end h-100 justify-content-center mt-sm-0 mt-3">
														<img src="{{ asset('assets/img/illustrations/boy-with-laptop-' . $configData['style'] . '.png') }}"
																class="img-fluid" alt="Image" width="100"
																data-app-light-img="illustrations/boy-with-laptop-light.png"
																data-app-dark-img="illustrations/boy-with-laptop-dark.png">
												</div>
										</div>
										<div class="col-sm-7">
												<div class="card-body text-sm-end text-center ps-sm-0">
														<button data-bs-target="#add-setting-system" data-bs-toggle="modal"
																class="btn btn-primary mb-3 text-nowrap add-new-setting system">Add new setting system</button>
														<p class="mb-0">Add setting system, if it does not exist</p>
												</div>
										</div>
								</div>
						</div>
				</div>
				<!-- Role Table -->
				<div class="col-md-12">
						<div class="card">
								<div class="table-responsive text-nowrap">
										<table class="table table-hover">
												<thead>
														<tr>
																<th>#</th>
																<th>Key</th>
																<th>Value</th>
																<th>Display order</th>
																<th>Actions</th>
														</tr>
												</thead>
												<tbody class="table-border-bottom-0">
														@forelse ($settings as $item)
																<tr>
																		<th>@include('admin.includes._iteration', ['data' => $settings])</th>
																		<td><b>{{ $item->key }}</b></td>
																		<td>{{ $item->value }}</td>
																		<td>{{ $item->display_order }}</td>
																		<td>
																				<div class="dropdown">
																						<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
																								<i class="bx bx-dots-vertical-rounded"></i>
																						</button>
																						<div class="dropdown-menu">
																								<button data-bs-target="#edit-setting-system-{{ $item->id }}" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-edit-alt me-1"></i> Edit
																								</button>
																								<form action="{{ route('setting-system.destroy', ['setting_system' => $item]) }}" method="post">
																										@csrf
																										@method('delete')
																										<button type="submit" class="dropdown-item deleteAll"
																												data-msg="setting system - {{ $item->name }}">
																												<i class="bx bx-trash me-1"></i> Delete
																										</button>
																								</form>
																						</div>
																				</div>
																		</td>
																</tr>
																@include('admin.setting_system.system.edit', ['setting_system' => $item])
														@empty
																<tr>
																		<th>No record found.</th>
																</tr>
														@endforelse
												</tbody>
										</table>
								</div>
								<div class="card-footer">
										{{ $settings->links() }}
								</div>
						</div>
				</div>
		</div>
		@include('admin.setting_system.system.create')
@endsection
@section('page-script')
		<script type="text/javascript">
				let type = document.querySelector("#type");
				type.addEventListener("change", function(e) {
						e.preventDefault()
						let valueExist = document.querySelector("#valueExist");
						if (e.target.value.trim() !== '') {
								if (!valueExist) {
										type.parentNode.parentNode.insertAdjacentHTML("beforeend",
												`<div class="form-group mb-1" id="valueExist"> <label for="">value</label>
													<input type="${e.target.value}" class="form-control @error('type') is-invalid @enderror" name="value" placeholder="Value"></div>`);
								} else {
										type.parentNode.parentNode.removeChild(valueExist)
										type.parentNode.parentNode.insertAdjacentHTML("beforeend",
												`<div class="form-group mb-1" id="valueExist"><label for="">value</label>
													<input type="${e.target.value}" class="form-control @error('type') is-invalid @enderror" name="value" placeholder="Value"></div>`);
								}
						} else {
								debugger;
								if (valueExist) {
										type.parentNode.parentNode.removeChild(valueExist)
								}
						}
				});
		</script>
		<script type="text/javascript">
				let typeEdits = document.querySelectorAll(".typeEdit");
				typeEdits.forEach((type) => {
						type.addEventListener("change", function(e) {
								e.preventDefault()
								let valueExist = e.target.parentElement.parentElement.lastElementChild;
								if (e.target.value.trim() !== '') {
										if (!valueExist) {
												type.parentNode.parentNode.insertAdjacentHTML("beforeend",
														`<div class="form-group mb-1" id="valueExist"><label for="">value</label>
															<input type="${e.target.value}" class="form-control @error('type') is-invalid @enderror" name="value" placeholder="Value"></div>`);
										} else {
												type.parentNode.parentNode.removeChild(valueExist)
												type.parentNode.parentNode.insertAdjacentHTML("beforeend",
														`<div class="form-group mb-1" id="valueExist"><label for="">value</label>
															<input type="${e.target.value}" class="form-control @error('type') is-invalid @enderror" name="value" placeholder="Value"></div>`);
										}
								} else {
										debugger;
										if (valueExist) {
												type.parentNode.parentNode.removeChild(valueExist)
										}
								}
						});
				});
		</script>

		@if (count($errors) > 0)
				<script>
						$(document).ready(function() {
								$("#add-setting").modal('show');
						});
				</script>
		@endif

		@if (session()->has('errID'))
				<script>
						$(document).ready(function() {
								$("#edit-setting-{{ session()->get('errID') }}").modal('show');
						});
				</script>
		@endif
@endsection
