<div class="modal fade" id="edit-setting-system-{{ $setting_system->id }}" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-setting-system">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="setting-system-title">Edit setting - {{ Str::ucfirst($setting_system->key) }}</h3>
								</div>
								<form action="{{ route('setting-system.update', ['setting_system' => $setting_system]) }}" method="POST" class="row g-3">
										@csrf
										@method('patch')
										@php
												$err = 'errorEdit_' . $setting_system->id;
										@endphp
										<div class="col-12 mb-4">
												<label class="form-label" for="name">Setting system name</label>
												<input type="text" id="name" name="name"
														class="form-control @error('name', $err) is-invalid @enderror" placeholder="Enter a setting-system name"
														tabindex="-1" value="{{ old('name') ?? $setting_system->key }}" />
												@error('name', $err)
														<div class=" invalid-feedback">{{ $errors->$err->first('name') }}</div>
												@enderror
										</div>

										<div class="mb-3">
												<label for="name">Type of setting</label>
												<select class="form-control typeEdit @error('type') is-invalid @enderror" name="type">
														<option value="">select type</option>
														@foreach ($types as $t)
																<option value="{{ $t }}"{{ $t === $setting_system->type ? 'selected' : '' }}>
																		{{ Str::ucfirst($t) }}</option>
														@endforeach
												</select>
												@error('type')
														<div class="invalid-feedback">{{ $errors->first('type') }}</div>
												@enderror
										</div>
										@if (!is_null(old('type')) && old('value'))
												<div class="mb-3 valueExistEdit">
														<label for="">value</label>
														<input type="{{ old('type') ?? 'text' }}" class="form-control @error('type') is-invalid @enderror"
																name="value" placeholder="Value" value="{{ old('value') ?? '' }}">
														@error('value')
																<div class="invalid-feedback">{{ $errors->first('value') }}</div>
														@enderror
												</div>
										@else
												<div class="mb-3 valueExistEdit">
														<label for="">value</label>
														<input type="{{ old('type') ?? $setting_system->type }}"
																class="form-control @error('type') is-invalid @enderror" name="value" placeholder="Value"
																value="{{ old('value') ?? $setting_system->value }}">
														@error('value')
																<div class="invalid-feedback">{{ $errors->first('value') }}</div>
														@enderror
												</div>
										@endif
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Edit</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
