<div class="modal fade" id="add-setting-system" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-setting-system">
				<div class="modal-content p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="setting-system-title">Add new setting system</h3>
								</div>
								<form action="{{ route('setting-system.store') }}" method="POST" class="row g-3">
										@csrf
										<div class="modal-body">
												<div class="col-12 mb-4">
														<label class="form-label" for="name">Setting name</label>
														<input type="text" id="name" name="name"
																class="form-control @error('name') is-invalid @enderror" placeholder="Enter a setting system name"
																tabindex="-1" />
														@error('name')
																<div class=" invalid-feedback">{{ $errors->first('name') }}</div>
														@enderror
												</div>
												<label for="name">Type of setting</label>
												<div class="mb-3">
														<select class="form-control @error('type') is-invalid @enderror" id="type" name="type">
																<option value="">select type</option>
																@foreach ($types as $t)
																		<option value="{{ $t }}" {{ old('type') === $t ? 'selected' : '' }}>
																				{{ Str::ucfirst($t) }}
																		</option>
																@endforeach
														</select>
														@error('type')
																<div class="invalid-feedback">{{ $errors->first('type') }}</div>
														@enderror
												</div>
												@if (!is_null(old('type')) && old('value'))
														<div class="mb-3" id="valueExist">
																<label for="">value</label>
																<input type="{{ old('type') ?? 'text' }}" class="form-control @error('type') is-invalid @enderror"
																		name="value" placeholder="Value" value="{{ old('value') ?? '' }}">
																@error('value')
																		<div class="invalid-feedback">{{ $errors->first('value') }}</div>
																@enderror
														</div>
												@endif
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Save</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
