<x-modal idm="edit-change_rate-{{ $item->id }}" :title="__('edit') . ' : ' . $item->from_currency . ' - ' . $item->to_currency">
    <form action="{{ route('admin.change-rate.update', ['change_rate' => $item->id]) }}" method="post">
        @csrf
        @method('patch')
        @php
            $errID = 'errorEdit_' . $item->id;
        @endphp
        <div class="modal-body">
            <div class="row">
                <div class="mb-3">
                    <label for="name">From currency</label>
                    <input type="text"class="form-control" disabled value="{{ $item->from_currency }}">
                </div>
                <div class="mb-3">
                    <label for="name">To currency</label>
                    <input type="text"class="form-control" disabled value="{{ $item->to_currency }}">
                </div>
                <div class="col-lg-12">
                    <label for="name">Change rate</label>
                    <div class="form-group">
                        <input type="text" placeholder="Change rate" id="name"
                            class="form-control @error('rate', $errID) is-invalid @enderror" name="rate"
                            value="{{ old('rate') ?? $item->rate }}">
                        @error('rate', $errID)
                            <div class="invalid-feedback">{{ $errors->$errID->first('rate') }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        @include('admin.includes.modal-footer')
    </form>
</x-modal>
