<div class="modal fade" id="add-parcel_price" tabindex="-1" aria-hidden="true">
		<div class="modal-dialog add-new-parcel_price">
				<div class="modal-content  p-2">
						<button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
						<div class="modal-body">
								<div class="text-center mb-4">
										<h3 class="parcel_price-title">Add new parcel price</h3>
								</div>
								<form action="{{ route('parcel-price.store') }}" method="POST" class="row g-3">
										@csrf
										<div class="col-md-12 mb-0">
												<label class="form-label" for="category">Parcel category</label>
												<select class="form-select @error('category') is-invalid @enderror" id="category" name="category">
														<option value="">Select category</option>
														@foreach ($parcelCats as $cats)
																<option value="{{ $cats->id }}" @selected((int) old('category') === $cats->id)>
																		{{ Str::ucfirst($cats->name) }}
																</option>
														@endforeach
												</select>
												@error('category')
														<div class="invalid-feedback">{{ $errors->first('category') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0">
												<label class="form-label" for="reseller">Reseller group</label>
												<select class="form-select @error('reseller') is-invalid @enderror" id="reseller" name="reseller">
														<option value="">Select reseller group</option>
														@foreach ($reseller as $rsl)
																<option value="{{ $rsl->name }}" @selected(old('reseller') === $rsl->name)>
																		{{ Str::ucfirst($rsl->name) }}
																</option>
														@endforeach
												</select>
												@error('reseller')
														<div class="invalid-feedback">{{ $errors->first('reseller') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0">
												<label class="form-label" for="country_from">Country From</label>
												<select class="select2 form-select @error('country_from') is-invalid @enderror" id="country_from"
														name="country_from">
														<option value="">Country From</option>
														@foreach ($country as $from)
																<option value="{{ $from->code }}" @selected(old('country_from') === $from->code)>
																		{{ Str::ucfirst($from->name) }}
																</option>
														@endforeach
												</select>
												@error('country_from')
														<div class="invalid-feedback">{{ $errors->first('country_from') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-0">
												<label for="country_to" class="form-label">Country to export</label>
												<select id="country_to" class="select2 form-select @error('country_to') is-invalid @enderror" multiple
														name="country_to[]">
														<option value="">Country To</option>
														@foreach ($country as $to)
																<option value="{{ $to->code }}" @selected(in_array($to->code, is_string(old('country_to')) ? [] : old('country_to') ?? []))>
																		{{ Str::ucfirst($to->name) }}
																</option>
														@endforeach
												</select>
												@error('country_to')
														<div class="invalid-feedback">{{ $errors->first('country_to') }}</div>
												@enderror
										</div>
										<div class="col-md-6 mb-0">
												<label class="form-label" for="standard">Standard price</label>
												<input type="text" id="standard" class="form-control @error('standard') is-invalid @enderror"
														name="standard" placeholder="Standard price">
												@error('standard')
														<div class="invalid-feedback">{{ $errors->first('standard') }}</div>
												@enderror
										</div>
										<div class="col-md-6 mb-0">
												<label class="form-label" for="express">Express price</label>
												<input type="text" id="express" class="form-control @error('express') is-invalid @enderror"
														name="express" placeholder="Express price">
												@error('express')
														<div class="invalid-feedback">{{ $errors->first('express') }}</div>
												@enderror
										</div>
										<div class="col-md-12 mb-3">
												<label class="form-label" for="note">Note</label>
												<input type="text" id="note" class="form-control @error('note') is-invalid @enderror" name="note"
														placeholder="Note">
												@error('note')
														<div class="invalid-feedback">{{ $errors->first('note') }}</div>
												@enderror
										</div>
										<div class="col-12 text-center">
												<button type="submit" class="btn btn-primary me-sm-3 me-1">Save</button>
												<button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
														aria-label="Close">Cancel</button>
										</div>
								</form>
						</div>
				</div>
		</div>
</div>
