<?php

namespace App\classes\service;

use App\Models\Module;
use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Validator as ValidatorReturn;

class StatusService
{
  public function Index(Request $request)
  {
    $statuss =  Status::paginate(15);
    return $statuss;
  }
  public function Create(Request $request)
  {
    return Status::create([
      "name"    => trim(strtolower(htmlspecialchars($request->name))),
      "module"  => $request->module
    ]);
  }
  public function Update(Request $request, Status $status): Status
  {
    $status->update([
      "name"    => trim(strtolower(htmlspecialchars($request->name))),
      "module"  => $request->module
    ]);
    return $status;
  }

  public function Delete(Status $status): bool
  {
    return $status->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  Status|bool $status
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, Status|bool $status = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "module"  => ["required", "exists:modules,name"],
          "name"    => ["required", Rule::unique("statuses", "name")->where("module", $request->module)],
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "name"    => ["required", Rule::unique("statuses", "name")->where("module", $request->module)->ignore($status->id)],
          "module"  => ["required", "exists:modules,name"],
        ]);
      default:
        return null;
    }
  }
}
