<?php

namespace App\Http\Controllers\Admin;

use App\classes\service\StatusService;
use App\Models\Module;
use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class StatusController extends Controller
{
    private StatusService $statusService;
    public function __construct()
    {
        $this->statusService = new StatusService();
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $status     = $this->statusService->Index($request);
        $modules    = Module::get()->pluck("name", "id");
        return view("admin.status.index", compact("status", "modules"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        $data = $this->statusService->DataValidation($request, "post");
        if ($data->fails()) {
            return back()->withInput()->withErrors($data);
        }
        $status = $this->statusService->Create($request);
        return redirect()->route("status.index")->with("success", "Status successfully created.");
    }

    /**
     * Display the specified resource.
     */
    public function show(Status $status)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Status $status)
    {
        return view("admin.status.index", compact("status"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Status $status)
    {
        $data = $this->statusService->DataValidation($request, "patch", $status);
        if ($data->fails()) {
            return back()->withInput()->withErrors($data, "err_" . $status->id)->with("err", $status->id);
        }
        $status = $this->statusService->Update($request, $status);
        return redirect()->route("status.index")->with("success", "Status ($status->name) successfully updated.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Status $status)
    {
        $name = $status->name;
        $this->statusService->Delete($status);
        return redirect()->route("status.index")->with("success", "Status ($status->name) successfully updated.");
    }
}
