<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\maps\Leaflet;
use App\Http\Controllers\apps\AccessRoles;
use App\Http\Controllers\dashboard\Ecommerce;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\apps\AccessPermission;
use App\Http\Controllers\Admin\ModuleController;
use App\Http\Controllers\Admin\StatusController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\CurrencyController;
use App\Http\Controllers\Admin\ResellerController;
use App\Http\Controllers\Admin\CorporateController;
use App\Http\Controllers\Website\WebsiteController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\authentications\LoginCover;
use App\Http\Controllers\Admin\ParcelPriceController;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\Admin\SettingSystemController;
use App\Http\Controllers\Admin\ParcelCategoryController;
use App\Http\Controllers\laravel_example\UserManagement;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// AUTH - routes
Route::get('/', [WebsiteController::class, "index"])->name('home');
Route::get('/check', [WebsiteController::class, "check"])->name('check');
Route::post('/check_price', [WebsiteController::class, "check_price"])->name('check_price');
//Route::get("/admin", [LoginCover::class, "index"]);
// Route::get("/admin", [LoginCover::class, "index"])->name("admin");
Route::get("/sign-in", [WebsiteController::class, "create"])->name("sign-in");

Route::get("/register", [WebsiteController::class, "register"])->name("register");
Route::get("/contact", [WebsiteController::class, "contact"])->name("contact");
Route::get("/about", [WebsiteController::class, "about"])->name("about");
Route::post('/authenticate', [WebsiteController::class, 'authenticate'])->name('authenticate');
//Route::get("/about-us", [WebsiteController::class, "about"])->name("about-us");

// Route::get('/sign-in', function () {
//   return redirect('sign-in');
// });
Route::get("/login", [LoginCover::class, "index"])->name("login");


Route::post("/register", [WebsiteController::class, "store"])->name("register_client");
Route::get("/dashboard", [WebsiteController::class, "dashboard"])->name("dashboard");
Route::get("/confirmation", [WebsiteController::class, "confirmation"])->name("confirmation");
Route::get("/my-account", [WebsiteController::class, "my_account"])->name("my-account");
Route::get("/my-profile", [WebsiteController::class, "my_profile"])->name("my-profile");
Route::get("/service-point", [WebsiteController::class, "service_point"])->name("service-point");
Route::get("/quote", [WebsiteController::class, "quote"])->name("quote");
Route::get("/my-orders", [WebsiteController::class, "my_orders"])->name("my-orders");
Route::post("/book_collection", [WebsiteController::class, "book_collection"])->name("book_collection");
Route::get("/book_collection", [WebsiteController::class, "view_collection"])->name("book_collection");
Route::post("/login", [AuthController::class, "login"])->name("login.post");
Route::post("/logout", [AuthController::class, "logout"])->name("logout")->middleware("auth:web");
//Route::post('logout', [\App\Http\Controllers\Api\CorporateController::class, 'logout'])->name('logout');
// AUTH - routes

// Main Page Route
// Route::get('/dashboard/ecommerce', [Ecommerce::class, 'index'])->name('dashboard-ecommerce');
Route::group(["prefix" => "admin", "middleware" => "auth:web"], function () {
  Route::get('/', [Ecommerce::class, 'index'])->name('home.admin');

  // Module
  Route::resource("module", ModuleController::class);
  // Module
  Route::resource("setting-system", SettingSystemController::class);
  // Status
  Route::resource("status", StatusController::class);
  // Role
  Route::resource("role", RoleController::class);
  // Permission
  Route::resource("permission", PermissionController::class);
  // Module
  Route::resource("country", CountryController::class);
  Route::resource("currency", CurrencyController::class);
  // Users
  Route::resource("reseller", ResellerController::class);
  // Users
  Route::resource("user", UserController::class);
  Route::post("user/{user}/change-password", [UserController::class, "change_password"])->name("user.change-password");
  // Parcel category
  Route::resource("parcel-category", ParcelCategoryController::class);
  // Parcel price
  Route::resource("parcel-price", ParcelPriceController::class);
  // locale
  Route::get('lang/{locale}', [LanguageController::class, "swap"]);
  // maps
  Route::get('/maps/leaflet', [Leaflet::class, 'index'])->name('maps-leaflet');
});
