@extends('layouts.website.website')

@section('content')
		<!-- content begin -->
		<div class="no-bottom no-top" id="content">
				<div id="top"></div>
				<section id="section-hero" aria-label="section" class="jarallax full-height vertical-center">
						<img src="{{ asset('website/images/new2.jpg') }}" class="jarallax-img" alt="">
						<div class="container position-relative1 z1000">
								<div class="row align-items-center justify-content-center">
										<div class="col-lg-12 text-light">
												<h4><span class="id-color" style="padding-top:100px;">DHL courier services for express parcel deliver </span>
												</h4>
												<div class="spacer-10"></div>
												<h1 class="mb-2">DHL express courier
														services for UK to AFRICA parcel deliver via DUMA Expo</h1>
												<div class="spacer-10"></div>
												<p class="lead">Looking to send a parcel abroad or within the UK? Get a quote and choose the courier
														collection or drop-off delivery service that suits you best!</p>
										</div>
										<div class="col-lg-10">
												<div class="spacer-single sm-hide"></div>
												<div class="p-4 rounded-3 shadow-soft" data-bgcolor="#ffffff">
														<form name="contactForm" id='contact_form' method="get" action="{{ route('check') }}">
																<div class="spacer-20"></div>
																<div class="row">
																		<div class="col-lg-6 mb20">
																				<h5>From</h5>
																				<select class="form-control" disabled>
																						<option>
																								Select a country
																						</option>
																						@foreach ($countries as $item)
																								@if ($item->code === 'uk')
																										<option value="uk" selected>
																												{{ Str::ucfirst($item->name) }}
																										</option>
																								@endif
																						@endforeach
																				</select>

																				<div class="jls-address-preview jls-address-preview--hidden">
																						<div class="jls-address-preview__header">
																						</div>
																				</div>
																		</div>
																		<div class="col-lg-6 mb20">
																				<h5>To</h5>
																				<select class="form-control">
																						<option>
																								Select a country
																						</option>
																						@foreach ($countries as $item)
																								@if ($item->code != 'uk')
																										<option>
																												{{ Str::ucfirst($item->name) }}
																										</option>
																								@endif
																						@endforeach
																				</select>
																				<div class="jls-address-preview jls-address-preview--hidden">
																						<div class="jls-address-preview__header">
																						</div>
																				</div>
																		</div>

																		<div class="col-lg-3 mb20">
																				<h5>Weight</h5>
																				<div class="input-group input-group-merge">
																						<input type="text" class="form-control" placeholder="Weight" aria-label="Weight" name="weight">
																						<span class="input-group-text" id="basic-addon33">Kg</span>
																				</div>
																		</div>
																		<div class="col-lg-3 mb20">
																				<h5>Length</h5>
																				<div class="input-group input-group-merge">
																						<input type="text" class="form-control" placeholder="Length" aria-label="Length" name="length">
																						<span class="input-group-text" id="basic-addon33">cm</span>
																				</div>
																		</div>
																		<div class="col-lg-3 mb20">
																				<h5>Height</h5>
																				<div class="input-group input-group-merge">
																						<input type="text" class="form-control" placeholder="Height" aria-label="Height" name="height">
																						<span class="input-group-text" id="basic-addon33">cm</span>
																				</div>
																		</div>
																		<div class="col-lg-3 mb20">
																				<h5>Width</h5>
																				<div class="input-group input-group-merge">
																						<input type="text" class="form-control" placeholder="Width" aria-label="Width" name="width">
																						<span class="input-group-text" id="basic-addon33">cm</span>
																				</div>
																		</div>

																		<div class="col-lg-12 mb20">
																				<input type='submit' id='send_message' value='Get a quote' class="btn-main pull-right">
																		</div>

																		<div class="col-md-12">
																				<div class="de-icon-box">
																						<h4>Your results for delivery to Burundi</h4>
																						<p class="mb-3"><b>£78.64</b> Estimated delivery time: 1 working day</p>
																						<a class="btn-main btn-fullwidth" href="#">Book online</a>
																				</div>
																		</div>

																</div>
																<div class="clearfix"></div>
														</form>
												</div>
										</div>
								</div>
						</div>
				</section>
		</div>
		<!-- content close -->
		<a href="#" id="back-to-top"></a>
@endsection
