@extends('layouts.website.website')

@section('content')
<!-- content begin -->
<div class="no-bottom no-top" id="content">
	<div id="top"></div>
	<section id="section-hero" aria-label="section" class="jarallax full-height vertical-center">
		<img src="{{ asset('website/images/new2.jpg') }}" class="jarallax-img" alt="">
		<div class="container position-relative1 z1000">
			<div class="row align-items-center justify-content-center">
				<div class="col-lg-12 text-light">
					<h4><span class="id-color" style="padding-top:100px;">DHL courier services for express parcel deliver </span>
					</h4>
					<div class="spacer-10"></div>
					<h1 class="mb-2">DHL express courier
						services for UK to AFRICA parcel deliver via DUMA Expo</h1>
					<div class="spacer-10"></div>
					<p class="lead">Looking to send a parcel abroad or within the UK? Get a quote and choose the courier
						collection or drop-off delivery service that suits you best!</p>
				</div>
				<div class="col-lg-10">
					<div class="spacer-single sm-hide"></div>
					<div class="p-4 rounded-3 shadow-soft" data-bgcolor="#ffffff">
						<form name="contactForm" id='contact_form' method="get" action="{{ route('check') }}">
							<div class="spacer-20"></div>
							<div class="row">
								<div class="col-lg-4 mb-3">
									<h5>From</h5>
									<select class="form-control @error('from_country') is-invalid @enderror" name="from_country">
										<option value="">Select a country</option>
										@foreach ($countries as $item)
										@if ($item->code === 'uk')
										<option value="uk" selected @selected(old('from_country')===$item->code)>
											{{ Str::ucfirst($item->name) }}
										</option>
										@endif
										@endforeach
									</select>
									@error('from_country')
									<div class="invalid-feedback">{{ $errors->first('from_country') }}</div>
									@enderror
								</div>

								<div class="col-lg-4 mb-3">
									<h5>To</h5>
									<select class="form-control @error('to_country') is-invalid @enderror" name="to_country">
										<option value="">Select a country</option>
										@foreach ($countries as $item)
										@if ($item->code !== 'uk')
										<option value="{{ $item->code }}" @selected(old('to_country')===$item->code)>
											{{ Str::ucfirst($item->name) }}
										</option>
										@endif
										@endforeach
									</select>
									@error('to_country')
									<div class="invalid-feedback">{{ $errors->first('to_country') }}</div>
									@enderror
								</div>

								<div class="col-lg-4 mb-3">
									<h5>Type of Documents</h5>
									<select class="form-control" name="document_type">
										<option value="document">Document</option>
										<option value="non_document">Non Document</option>
									</select>
								</div>

								<div class="col-lg-3 mb-3">
									<h5>Weight</h5>
									<div class="input-group input-group-merge">
										<input type="number" step="0.001" class="form-control @error('weight') is-invalid @enderror" placeholder="Weight" aria-label="Weight" name="weight" value="{{ old('weight') }}">
										<span class="input-group-text" id="basic-addon33">Kg</span>
										@error('weight')
										<div class="invalid-feedback">{{ $errors->first('weight') }}</div>
										@enderror
									</div>
								</div>
								<div class="col-lg-3 mb-3">
									<h5>Length</h5>
									<div class="input-group input-group-merge">
										<input type="number" step="0.001" class="form-control @error('length') is-invalid @enderror" placeholder="Length" aria-label="Length" name="length" value="{{ old('length') }}">
										<span class="input-group-text" id="basic-addon33">cm</span>

										@error('length')
										<div class="invalid-feedback">{{ $errors->first('length') }}</div>
										@enderror
									</div>
								</div>
								<div class="col-lg-3 mb-3">
									<h5>Height</h5>
									<div class="input-group input-group-merge">
										<input type="number" step="0.001" class="form-control @error('height') is-invalid @enderror" placeholder="Height" aria-label="Height" name="height" value="{{ old('height') }}">
										<span class="input-group-text" id="basic-addon33">cm</span>

										@error('height')
										<div class="invalid-feedback">{{ $errors->first('height') }}</div>
										@enderror
									</div>
								</div>
								<div class="col-lg-3 mb-3">
									<h5>Width</h5>
									<div class="input-group input-group-merge">
										<input type="number" step="0.001" class="form-control @error('width') is-invalid @enderror" placeholder="Width" aria-label="Width" name="width" value="{{ old('width') }}">
										<span class="input-group-text" id="basic-addon33">cm</span>

										@error('width')
										<div class="invalid-feedback">{{ $errors->first('width') }}</div>
										@enderror
									</div>
								</div>

								<div class="col-lg-12 my-4">
									<input type='submit' id='send_message' value='Get a quote' class="btn-main pull-right">
								</div>
								<!-- 
																		<div class="col-md-12">
																				<div class="de-icon-box">
																						<h4>Your results for delivery to Burundi</h4>
																						<p class="mb-3"><b>£78.64</b> Estimated delivery time: 1 working day</p>
																						<a class="btn-main btn-fullwidth" href="#">Book online</a>
																				</div>
																		</div> -->

							</div>
							<div class="clearfix"></div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</section>

	{{-- <section id="section-cars">
						<div class="container">
								<div class="row">
										<div class="col-lg-12">
												<div class="row">
														<div class="col-xl-4 col-lg-6">
																<div class="de-item mb30">
																		<div class="d-img">
																				<img src="{{ asset('website/images/pinpoint-3d-icon-3.png') }}" class="img-fluid" alt="">
</div>
<div class="d-info">
	<div class="d-text">
		<h4 style="text-align: center;">Drop off at your local DHL Service Point
		</h4>
	</div>
</div>
<div class="d-price1" style="text-align: center; background:#e8e8e8; padding: 10px;">
	<h4>$265</span></h4>
	<p> Price based on using DHL Box 3</p>
	<p>VAT not charged</p>
	<p>Estimated delivery time*<br> 1 working day</p>
</div>
<div>
	<p style="text-align: center;">
		DHL Service Point, the easy way to send documents and parcels from your
		local high street or retail park!
	</p>
	<p><a class="btn-main" href="">Login....</a></p>
</div>
</div>
</div>

<div class="col-xl-4 col-lg-6">
	<div class="de-item mb30">
		<div class="d-img">
			<img src="{{ asset('website/images/pinpoint-3d-icon-3.png') }}" class="img-fluid" alt="">
		</div>
		<div class="d-info">
			<div class="d-text">
				<h4 style="text-align: center;">Drop off at your local DHL Service Point
				</h4>
			</div>
		</div>
		<div class="d-price1" style="text-align: center; background:#e8e8e8; padding: 10px;">
			<h4>$265</span></h4>
			<p> Price based on using DHL Box 3</p>
			<p>VAT not charged</p>
			<p>Estimated delivery time*<br>
				1 working day</p>

		</div>
		<div>
			<p style="text-align: center;">
				DHL Service Point, the easy way to send documents and parcels from your
				local high street or retail park!
			</p>
			<p><a class="btn-main" href="">Login....</a></p>
		</div>
	</div>


</div>

<div class="col-xl-4 col-lg-6">
	<div class="de-item mb30">
		<div class="d-img">
			<img src="{{ asset('website/images/pinpoint-3d-icon-3.png') }}" class="img-fluid" alt="">
		</div>
		<div class="d-info">
			<div class="d-text">
				<h4 style="text-align: center;">Drop off at your local DHL Service Point
				</h4>
			</div>
		</div>
		<div class="d-price1" style="text-align: center; background:#e8e8e8; padding: 10px;">
			<h4>$265</span></h4>
			<p> Price based on using DHL Box 3</p>
			<p>VAT not charged</p>
			<p>Estimated delivery time*<br>1 working day</p>
		</div>
		<div>
			<p style="text-align: center;">
				DHL Service Point, the easy way to send documents and parcels from your
				local high street or retail park!
			</p>
			<p><a class="btn-main" href="">Login....</a></p>
		</div>
	</div>
</div>
</div>
</div>
</div>
</div>
</section> --}}
</div>
<!-- content close -->
<a href="#" id="back-to-top"></a>
@endsection