@php
		$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Parcel category')
@section('vendor-style')
		<link rel="stylesheet" href="{{ asset('assets/vendor/libs/select2/select2.css') }}" />
@endsection
@section('content')
		@include('admin.includes.show-msg')
		<h4 class="py-3 breadcrumb-wrapper mb-2">Parcel categorys list</h4>
		<!-- Role cards -->
		<div class="row g-4">
				<div class="col-xl-12">
						<div class="card h-100">
								<div class="row h-100">
										<div class="col-sm-5">
												<div class="d-flex align-items-end h-100 justify-content-center mt-sm-0 mt-3">
														<img src="{{ asset('assets/img/illustrations/boy-with-laptop-' . $configData['style'] . '.png') }}"
																class="img-fluid" alt="Image" width="100"
																data-app-light-img="illustrations/boy-with-laptop-light.png"
																data-app-dark-img="illustrations/boy-with-laptop-dark.png">
												</div>
										</div>
										<div class="col-sm-7">
												<div class="card-body text-sm-end text-center ps-sm-0">
														<button data-bs-target="#add-parcel_category" data-bs-toggle="modal"
																class="btn btn-primary mb-3 text-nowrap add-new-parcel_category">Add New Parcel Category</button>
														<p class="mb-0">Add parcel category, if it does not exist</p>
												</div>
										</div>
								</div>
						</div>
				</div>
				<!-- Role Table -->
				<div class="col-md-12">
						<div class="card">
								<div class="table-responsive text-nowrap">
										<table class="table table-hover">
												<thead>
														<tr>
																<th>#</th>
																<th>Category name</th>
																<th class="text-center">Length * Height * Width</th>
																<th class="text-center">Weight (min-max)</th>
																<th>Actions</th>
														</tr>
												</thead>
												<tbody class="table-border-bottom-0">
														@forelse ($parcel_categorys as $item)
																<tr>
																		<th>@include('admin.includes._iteration', ['data' => $parcel_categorys])</th>
																		<td>{{ Str::ucfirst($item->name) }}</td>
																		<td class="text-center">
																				Min:&nbsp;{{ $item->length_min . ' x ' . $item->height_min . ' x ' . $item->width_min }} cm<br />
																				Max:&nbsp;{{ $item->length_max . ' x ' . $item->height_max . ' x ' . $item->width_max }} cm
																		</td>
																		<td class="text-center">
																				{{ $item->weight_min }}kg <b>to</b> {{ $item->weight_max }}kg
																		</td>
																		<td>
																				<div class="dropdown">
																						<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
																								<i class="bx bx-dots-vertical-rounded"></i>
																						</button>
																						<div class="dropdown-menu">
																								<button data-bs-target="#edit-parcel_category-{{ $item->id }}" data-bs-toggle="modal"
																										class="dropdown-item">
																										<i class="bx bx-edit-alt me-1"></i> Edit
																								</button>
																								<form action="{{ route('parcel-category.destroy', ['parcel_category' => $item]) }}"
																										method="post">
																										@csrf
																										@method('delete')
																										<button type="submit" class="dropdown-item deleteAll"
																												data-msg="parcel_category - {{ $item->name }}">
																												<i class="bx bx-trash me-1"></i> Delete
																										</button>
																								</form>
																						</div>
																				</div>
																				@include('admin.parcel_category.edit', ['parcel_category' => $item])
																		</td>
																</tr>
														@empty
																<tr>
																		<th>No record found.</th>
																</tr>
														@endforelse
												</tbody>
										</table>
								</div>
								<div class="card-footer">
										{{ $parcel_categorys->links() }}
								</div>
						</div>
				</div>
		</div>
		@include('admin.parcel_category.create')
@endsection

@section('page-script')
		<script src="{{ asset('assets/js/forms-selects.js') }}"></script>
		<script src="{{ asset('assets/js/forms-extras.js') }}"></script>
		@if (count($errors) > 0)
				@dump($errors)
				<script>
						$(document).ready(function() {
								$("#add-parcel_category").modal('show');
						});
				</script>
		@endif

		@if (session()->has('err'))
				<script>
						$(document).ready(function() {
								$("#edit-parcel_category-" + {{ session()->get('err') }}).modal('show');
						});
				</script>
		@endif
@endsection

@section('vendor-script')
		<script src="{{ asset('assets/vendor/libs/select2/select2.js') }}"></script>
		<script src="{{ asset('assets/vendor/libs/jquery-repeater/jquery-repeater.js') }}"></script>
@endsection
