<?php

namespace App\classes;

use Illuminate\Support\Facades\Cookie;

class ParcelCookie
{
    /**
     * setData
     * Put data in shopping cart
     * @param  array $data
     * @return void
     */
    public static function setData(array $data)
    {
        $time = (60 * 60 * 24 * 30);
        return Cookie::queue(Cookie::make("parcel", json_encode($data), $time));
    }

    /**
     * getData
     *
     * @return array
     */
    public static function getData()
    {
        $data = json_decode(Cookie::get("parcel"), true) ?? [];
        return $data;
    }

    /**
     * getDataByKeys
     *
     * @param  string $key
     * @return array|string|int|float
     */
    public static function getDataByKeys(String $key)
    {
        $key = trim(htmlentities(strtolower($key)));
        $data = json_decode(Cookie::get("parcel"), true) ?? [];
        if (isset($key) && $key !== "") {
            return $data[$key];
        }
    }
}
