<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParcelPrice extends Model
{
    use HasFactory;

    protected $fillable = ["parcel_category_id", "reseller", "country_from", "country_to", "price_standard", "price_express", "note"];

    public function parcel_category()
    {
        return $this->belongsTo(ParcelCategory::class);
    }

    public function from()
    {
        return $this->belongsTo(Country::class, "country_from", "code");
    }

    public function to()
    {
        return $this->belongsTo(Country::class, "country_to", "code");
    }
}
