<?php

namespace App\Http\Controllers\Admin;

use App\Classes\Langs;

use Illuminate\Http\Request;
use App\Models\SettingSystem;
use Illuminate\Http\Response;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Validator;

class SettingSystemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    private $type = ["text", "number", "url", "date", "file"];
    public function index()
    {
        $settings = SettingSystem::orderBy("display_order", "asc")->paginate(15);
        $types = $this->type;
        return view("admin.setting_system.system.index", compact("settings", "types"));
    }

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return Response|RedirectResponse
     */
    public function store(Request $request)
    {
        Validator::make($request->all(), [
            "name" => ["required", "string", "unique:setting_systems,key"],
            "type" => ["required", "in:" . implode(",", $this->type)],
            "value" => ["required"]
        ])->validate();

        $last = SettingSystem::all()->last();
        $data = [
            'key' => trim(htmlspecialchars(strtolower($request->name))),
            'type' => trim(htmlspecialchars(strtolower($request->type))),
            'display_order' => is_null($last) ? 1 : $last->display_order + 1,
        ];
        if ($request->type === 'file') {
            $data["value"] = $request->value->store("settings", "public");
        } else {
            $data["value"] = trim(htmlspecialchars(strtolower($request->value)));
        }
        SettingSystem::create($data);
        return redirect()->route("setting-system.index")->with("success", "Setting created with success !!!");
    }

    public function show(SettingSystem $settingSystem)
    {
        //
    }

    public function edit(SettingSystem $settingSystem)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SettingSystem  $settingSystem
     * @return Response|RedirectResponse
     */
    public function update(Request $request, SettingSystem $settingSystem)
    {
        $data = Validator::make($request->all(), [
            "name" => ["required", "string", Rule::unique("setting_systems", "key")->ignore($settingSystem->id)],
            "type" => ["required", "in:" . implode(",", $this->type)],
            "value" => ["required"]
        ]);
        if ($data->fails()) {
            return back()->withErrors($data, 'errorEdit_' . $settingSystem->idn)->with("errID", $settingSystem->idn)->withInput();
        }
        $last = SettingSystem::all()->last();
        $data = [
            'key' => trim(htmlspecialchars(strtolower($request->name))),
            'type' => trim(htmlspecialchars(strtolower($request->type))),
        ];
        if ($request->type === 'file') {
            $data["value"] = $request->value->store("settings", "public");
        } else {
            $data["value"] = trim(htmlspecialchars(strtolower($request->value)));
        }
        $settingSystem->update($data);
        return redirect()->route("setting-system.index")->with("success", "Setting updated with success with success !!!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SettingSystem  $settingSystem
     * @return \Illuminate\Http\Response
     */
    public function destroy(SettingSystem $settingSystem)
    {
        $settingSystem->delete();
        return redirect()->route("setting-system.index");
    }
}
