<?php

namespace App\classes\service;

use App\Models\ParcelPrice;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator as ValidatorReturn;

class ParcelPriceService
{
  public function Index(Request $request)
  {
    $parcel_prices =  ParcelPrice::orderBy('parcel_category_id')->paginate(20);
    return $parcel_prices;
  }
  public function Create(Request $request)
  {
    try {
      $note           = trim(htmlspecialchars(strtolower($request->note)));
      $express        = (float)trim(htmlspecialchars($request->express));
      $standard       = (float)trim(htmlspecialchars($request->standard));
      $reseller       = trim($request->reseller);
      $alreayExist    = array_unique(ParcelPrice::where("country_from", $request->country_from)->whereIn("country_to", $request->country_to)->get()->pluck("country_to")->toArray());
      $exportCountry  = array_diff($request->country_to, $alreayExist);
      //dd($exportCountry);
      foreach ($exportCountry as $to_country) {
        if ($request->country_from === $to_country) {
          continue;
        }
        $data = [
          "parcel_category_id"  => (int)$request->category,
          "reseller"            => $reseller !== "" ? $reseller : null,
          "country_from"        => $request->country_from,
          "country_to"          => $to_country,
          "price_standard"      => $standard,
          "price_express"       => $express === 0 ? $express : $standard,
          "note"                => $note !== "" ? $note : null,
        ];

        dd($data);
        ParcelPrice::firstOrCreate($data);
      }
      return true;
    } catch (Exception $e) {
      return back()->withInput()->with("error", "An error occcured while save parcel prices");
    }
  }
  public function Update(Request $request, ParcelPrice $parcel_price): ParcelPrice
  {
    $note         = trim(htmlspecialchars(strtolower($request->note)));
    $reseller     = trim($request->reseller);
    $alreayExist  = ParcelPrice::where("id", "!=", $parcel_price->id)->where("country_from", $request->country_from)->where("country_to", $request->country_to)->first();
    if (!is_null($alreayExist)) {
      return $parcel_price;
    }
    $data = [
      "parcel_category_id"  => (int)$request->category,
      "reseller"            => $reseller !== "" ? $reseller : null,
      "country_from"        => $request->country_from,
      "country_to"          => $request->country_to[0],
      "price_standard"      => (float)trim(htmlspecialchars($request->standard)),
      "price_express"       => (float)trim(htmlspecialchars($request->express)),
      "note"                => $note !== "" ? $note : null,
    ];
    $parcel_price->update($data);
    return $parcel_price;
  }

  public function Delete(ParcelPrice $parcel_price): bool
  {
    return $parcel_price->delete();
  }
  /**
   * Validation
   *
   * @param  Request $request
   * @param  string $method
   * @param  ParcelPrice|bool $parcel_price
   * @return ValidatorReturn|null
   */
  public function DataValidation(Request $request, String $method, ParcelPrice|null $parcel_price = null): ValidatorReturn|null
  {
    switch (strtolower($method)) {
      case 'post':
        return Validator::make($request->all(), [
          "category"      => ["required", "exists:parcel_categories,id", "distinct:strict"],
          "reseller"      => ["nullable", "string", "exists:resellers,name"],
          "country_from"  => ["required", "string", "exists:countries,code"],
          "country_to"    => ["required", "array", "distinct:strict", "exists:countries,code"],
          "standard"      => ["required", "numeric", "min:0"],
          "express"       => ["nullable", "numeric", "min:0"],
        ]);
      case 'patch':
        return Validator::make($request->all(), [
          "category"      => ["required", "exists:parcel_categories,id", "distinct:strict"],
          "reseller"      => ["nullable", "string", "exists:resellers,name"],
          "country_from"  => ["required", "string", "exists:countries,code"],
          "country_to"    =>  ["required", "array", "distinct:strict", "exists:countries,code"],
          "standard"      => ["required", "numeric", "min:0"],
          "express"       => ["nullable", "numeric", "min:0"],
        ]);
      default:
        return null;
    }
  }
}
