<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("user_id");
            $table->string("reference")->index();
            $table->integer("qty");
            $table->string("sub_total");
            $table->string("taxe")->default(0);
            $table->string("total");
            $table->string("currency");
            $table->string("payment_method");
            $table->string("payment_date")->nullable();
            $table->string("status");
            $table->timestamps();

            $table->foreign("user_id")->references("id")->on("users")->cascadeOnDelete()->cascadeOnDelete();
            $table->foreign("currency")->references("code")->on("currencies")->cascadeOnDelete()->cascadeOnDelete();
            $table->foreign("payment_method")->references("name")->on("payment_methods")->cascadeOnDelete()->cascadeOnDelete();
            $table->foreign("status")->references("name")->on("statuses")->cascadeOnDelete()->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
