<?php

namespace App\Http\Controllers\Admin;

use App\Models\Reseller;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\classes\service\ResellerService;

class ResellerController extends Controller
{
    private ResellerService $resellerService;

    public function __construct()
    {
        $this->resellerService = new ResellerService();
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $resellers = $this->resellerService->Index($request);
        return view("admin.reseller.index", compact("resellers"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $this->resellerService->DataValidation($request, "post");
        if ($data->fails()) {
            return back()->withInput()->withErrors($data);
        }
        $reseller = $this->resellerService->Create($request);
        return redirect()->route("reseller.index")->with("success", "Reseller successfully created.");
    }

    /**
     * Display the specified resource.
     */
    public function show(Reseller $reseller)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Reseller $reseller)
    {
        return view("admin.reseller.index", compact("reseller"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Reseller $reseller)
    {
        $data = $this->resellerService->DataValidation($request, "patch", $reseller);
        if ($data->fails()) {
            return back()->withInput()->withErrors($data, "err_" . $reseller->id)->with("err", $reseller->id);
        }
        $reseller = $this->resellerService->Update($request, $reseller);
        return redirect()->route("reseller.index")->with("success", "Reseller ($reseller->name) successfully updated.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Reseller $reseller)
    {
        $name = $reseller->name;
        $this->resellerService->Delete($reseller);
        return redirect()->route("reseller.index")->with("success", "Reseller ($reseller->name) successfully updated.");
    }
}
